# Codes

## make_input_dynamic.cpp

This code is for reading input from a SNAP dataset and making it dynamic.
That means, we add vertices of the input graph in random order and delete each of them
after `W` insertion. The output format of this file (which is the input of oracle.cpp) is like this:

* First line has three values, `M N K`, which indicate the number of edges, the number of updates on vertices, and the cardinality constraint
* Next `M` lines contain two values which indicate edges of the graph
* Next `N` lines indicate updates on the graph. If the value is positive it means we add the element and if it is negative, it means we remove it.

## oracle.cpp

This code read data from the output of `make_input_dynamic.cpp` and calls `add_element` and `remove_element` which should be implemented in every algorithm.
In addition, this code answers each call of f(S) and computes it. Also, it calculates the number of calls of f(S) and the average output of the algorithm.
We implement f_additive(S) in this code to find f(S) faster. Every algorithm can call it instead of f(S). More instruction is written in `oracle.cpp`.

## oracle.h

You should include this file in every algorithm you are implementing. It only contains signatures of shared functions.

## dynamic_algorithm.cpp

Here we implement our first dynamic algorithm.

## sample_streaming.cpp

Here we implement the sample streaming algorithm of Feldman, Karbasi, and Kazemi.

# Run codes

For running a code named `a.cpp` (e.g. `dynamic_algoirthm.cpp`), you should implement
functions `init(k)`, `add_element(element_id)`, and `remove_element(element_id)` in `a.cpp`.
Also, you should include `oracle.h` in your code. Then you can compile and run it with these commands:

    g++ a.cpp oracle.cpp -O2 -o a.out
    ./a.out

Also, for generating a dynamic input from a SNAP dataset (e.g. web-Stanford.txt),
you should compile and run the `make_input_dynamic.cpp` by this commands:

    g++ make_input_dynamic.cpp -O2 -o make_input_dynamic
    ./make_input_dynamic < web-Stanford.txt


# Data

We use SNAP dataset. You can find it here:\
http://snap.stanford.edu/data/ 